﻿//////////////////////////////////////////////
// ProfilingHelper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "ProfilingInfoHolder.h"

#include "../Dll/DllDefines.h"

// Standards
#include <functional>

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ProfilingHelper
	{			
		public :
		
			// Constructor, destructor
			ProfilingHelper () noexcept ;
			virtual ~ProfilingHelper () ;

			// Getters
			const ProfilingInfoHolder& getLastComputedInfo () const ;

			// Setters
			void setInfoCallback (std::function<void (const ProfilingInfoHolder&)> value) ;
			virtual void setGpuTimeProfilingActivated (bool value) ;
			virtual void setCpuTimeProfilingActivated (bool value) ;
			virtual void setStatisticsProfilingActivated (bool value) ;		

			// Implementation
			virtual void preOperationRoutine () = 0 ;
			virtual void postOperationRoutine () = 0 ;

		protected :

			// Attributes
			// Callback
			std::function<void (const ProfilingInfoHolder&)> _doneCallback ;

			// Data
			ProfilingInfoHolder _lastComputedInfo ;

			// Flags
			bool _gpuTimeTracked ;
			bool _cpuTimeTracked ;
			bool _statsTimeTracked ;
	} ;
}